/*
 * Decompiled with CFR 0.152.
 */
package com.pfg.mi1robot;

import com.pfg.mi1robot.Bitmap;
import com.pfg.mi1robot.Comandos;
import com.pfg.mi1robot.Escenario;
import com.pfg.mi1robot.Robot;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Movimiento
extends Comandos {
    private int direccion;

    public Movimiento(int direccion, int X, int Y, Bitmap grafico) {
        this.direccion = direccion < 0 || direccion > 4 ? 0 : direccion;
        this.setNombre("Movimiento");
        this.setTipo("Flujo");
        this.setX(X);
        this.setY(Y);
        this.grafico = grafico;
    }

    @Override
    public void draw(Graphics g, int xcord, int ycord) {
        g.drawImage(this.grafico.getImagen(), this.getX() - xcord, this.getY() - ycord, null);
    }

    public int getDireccion() {
        return this.direccion;
    }

    @Override
    public void exec(Robot robot, Escenario escenario) {
        this.sndPool.start();
        robot.mover(this.direccion, this.getTablero());
    }

    @Override
    public Comandos clone() {
        return new Movimiento(this.direccion, this.getX(), this.getY(), this.grafico);
    }

    @Override
    public void loadSound() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream("movimiento.wav"));
        AudioInputStream ais = AudioSystem.getAudioInputStream(bis);
        this.sndPool = AudioSystem.getClip();
        this.sndPool.open(ais);
    }

    @Override
    public void save(BufferedWriter writer) throws IOException {
        switch (this.direccion) {
            case 0: {
                writer.write("Abajo");
                break;
            }
            case 1: {
                writer.write("Arriba");
                break;
            }
            case 2: {
                writer.write("Izquierda");
                break;
            }
            case 3: {
                writer.write("Derecha");
            }
        }
    }
}

